<?php
// Add new input type "switch"
if ( function_exists('smile_add_input_type'))
{
	smile_add_input_type('switch' , 'switch_settings_field' );
}

add_action('admin_enqueue_scripts','smile_switch_image_scripts');
function smile_switch_image_scripts($hook){
	$cp_page = strpos( $hook, 'plug_page');
	$data  =  get_option( 'convert_plug_debug' );

	if( isset( $data['cp-dev-mode'] ) && $data['cp-dev-mode'] == '1' ) {
			wp_enqueue_style('smile-switch',plugins_url('switch.css',__FILE__));
			wp_enqueue_script('smile-switch',plugins_url('switch.js',__FILE__),array(),'1.0.0',true);
	}
}

/**
* Function to handle new input type "switch"
*
* @param $settings		- settings provided when using the input type "switch"
* @param $value			- holds the default / updated value
* @return string/html 	- html output generated by the function
*/
function switch_settings_field($name, $settings, $value)
{
	//var_dump($value);
	$input_name = $name;
	$type = isset($settings['type']) ? $settings['type'] : '';
	$class = isset($settings['class']) ? $settings['class'] : '';
	$on = isset($settings['on']) ? $settings['on'] : 'ON';
	$off = isset($settings['off']) ? $settings['off'] : 'OFF';
	$checked = ($value) ? 'checked="checked"' : '';
	$uniq = uniqid();
	$output = '<div class="switch-wrapper">';

	$output .= '<input type="text" '.$checked.' id="smile_'.$input_name.'" class="form-control smile-input smile-switch-input '.$class.'" name="' . $input_name . '" value="'.$value.'" />';
	$output .= '<input type="checkbox" '.$checked.' id="smile_'.$input_name.'_btn_'.$uniq.'" class="ios-toggle smile-input smile-switch-input switch-checkbox smile-'.$type.' '.$class.'" value="'.$value.'"   >';
	$output .= '<label class="smile-switch-btn checkbox-label" data-on="'.$on.'"  data-off="'.$off.'" data-id="smile_'.$input_name.'" for="smile_'.$input_name.'_btn_'.$uniq.'">
				</label>';
	$output .= '</div>';
	return $output;
}